----------------
title : C++ 레퍼런스 - string_view 생성자
cat_title :  string_view
ref_title : string_view, std::string_view, wstring_view, std::wstring_view
path : /C++ Reference/string_view
----------------

##@ cpp-ref-start

#@ string_view 생성자

```cpp-formatted
constexpr basic_string_view() noexcept;  // (1)
constexpr basic_string_view(const basic_string_view& other) noexcept =
  default;                                                     // (2)
constexpr basic_string_view(const CharT* s, size_type count);  // (3)
constexpr basic_string_view(const CharT* s);                   // (4)
```

`basic_string_view` 를 생성한다. `string_view` 를 왜 쓰는지 궁금하다면 `basic_string_view` 를 참조.

1. 디폴트 생성자로, 비어있는 `basic_string_view` 를 생성한다. 생성 후에, `data` 는 `nullptr` 로 설정되고, `size` 는 0 으로 설정된다.
2. 복사 생성자로, 인자로 전달된 `string_view` 와 동일한 문자열을 가리킨다.
3. s 가 가리키는 문자 배열로 부터 `count` 개의 문자를 취하는 `string_view` 를 생성한다. `s` 중간에 `NULL` 문자가 있어도 문제 없다.
4. 널 종료 문자열을 가리키는 `s` 로 부터 `string_view` 를 생성한다.

참고로 `string_view` 는 `basic_string_view` 에서 문자의 타입으로 `char` 을 취했을 때의 버전입니다. 만일 `char` 대신에 `wchar_t` 를 사용한다면 `wstring_view` 를 사용하시면 됩니다.

### 인자

* `other`	-	복사 생성할 다른 `string_view`
* `s`	-	view 할 다른 문자열을 가리키는 포인터
* `count`	-	몇 개의 문자들을 `view` 할 것인지

### 복잡도

1, 2, 3 번의 경우 단순히 포인터와 길이만 받으면 되기 때문에 $$O(1)$$ 로 수행할 수 있습니다. (매우 빠릅니다!)

반면에 4 번의 경우, 문자열의 길이를 세야 하기 때문에, $$O(n)$$ 이 됩니다.

### 예시

```cpp-formatted
#include <iostream>
#include <string>
#include <string_view>
int main() {
  std::wstring_view wcstr_v = L"xyzzy";

  char array[3] = {'B', 'a', 'r'};
  std::string_view array_v(array, std::size(array));

  std::string cppstr = "Foo";
  std::string_view cppstr_v(&cppstr[0], cppstr.size());

  std::cout << cppstr_v << '\n' << array_v << '\n' << wcstr_v.size() << '\n';
}
```

실행 결과

```exec
Foo
Bar
5
```